/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberFormatOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberFormatOp.class);
    private static final long serialVersionUID = 4805636716328583550L;

    public DingoNumberFormatOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String formatNumber(double value, int scale) {
        if (scale < 0) {
            scale = 0;
        }
        BigDecimal decimal = new BigDecimal(value).setScale(scale, 4);
        return decimal.toString();
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        int inputScalar = new BigDecimal(String.valueOf(values[1])).setScale(0, 4).intValue();
        if (inputScalar < 0) {
            inputScalar = 0;
        }
        BigDecimal decimal = new BigDecimal(String.valueOf(values[0])).setScale(inputScalar, 4);
        return DingoNumberFormatOp.formatNumber(decimal.doubleValue(), inputScalar);
    }

    @Override
    public int typeCode() {
        return 761287205;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberFormatOp::new;
        }

        public List<String> name() {
            return Arrays.asList("format");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberFormatOp.class.getMethod("formatNumber", Double.TYPE, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

