/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberModOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberModOp.class);

    public DingoNumberModOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static BigDecimal mod(BigDecimal value1, BigDecimal value2) {
        return value1.remainder(value2);
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        if (values[0] == null || values[1] == null) {
            return null;
        }
        BigDecimal value1 = new BigDecimal(String.valueOf(values[0]));
        BigDecimal value2 = new BigDecimal(String.valueOf(values[1]));
        if (value2.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return DingoNumberModOp.mod(value1, value2);
    }

    @Override
    public int typeCode() {
        return -1405464277;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberModOp::new;
        }

        public List<String> name() {
            return Arrays.asList("mod");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberModOp.class.getMethod("mod", BigDecimal.class, BigDecimal.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

