/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberPowOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberPowOp.class);

    public DingoNumberPowOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static BigDecimal pow(BigDecimal value, BigDecimal power) {
        int powerInt = power.intValue();
        if (powerInt < 0) {
            try {
                return BigDecimal.ONE.divide(value.pow(-powerInt));
            }
            catch (ArithmeticException exception) {
                return BigDecimal.ONE.divide(value.pow(-powerInt), 16, RoundingMode.HALF_DOWN);
            }
        }
        BigDecimal intDecimal = value.setScale(0, 3);
        if (value.compareTo(intDecimal) == 0) {
            return intDecimal.pow(powerInt);
        }
        return value.pow(powerInt);
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        if (values[0] == null || values[1] == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(String.valueOf(values[0]));
        BigDecimal power = new BigDecimal(String.valueOf(values[1]));
        if (power.scale() > 0) {
            throw new RuntimeException("Parameter is invalid");
        }
        return DingoNumberPowOp.pow(value, power);
    }

    @Override
    public int typeCode() {
        return -1405464277;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberPowOp::new;
        }

        public List<String> name() {
            return Arrays.asList("pow");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberPowOp.class.getMethod("pow", BigDecimal.class, BigDecimal.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

