/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberRoundOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberRoundOp.class);

    public DingoNumberRoundOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static BigDecimal round(BigDecimal value, int scale) {
        if (scale >= 0) {
            return value.setScale(scale, RoundingMode.HALF_UP);
        }
        long temp = 1L;
        for (int i = 1; i <= -scale; ++i) {
            temp *= 10L;
        }
        BigDecimal divide = value.divide(new BigDecimal(temp));
        if (divide.abs().compareTo(new BigDecimal(0.1)) < 0) {
            return new BigDecimal(0);
        }
        divide = divide.setScale(0, RoundingMode.HALF_UP);
        return divide.multiply(new BigDecimal(temp));
    }

    public static BigDecimal round(BigDecimal value) {
        return DingoNumberRoundOp.round(value, 0);
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        if (values.length == 1) {
            if (values[0] == null) {
                return null;
            }
            BigDecimal value = new BigDecimal(String.valueOf(values[0]));
            return DingoNumberRoundOp.round(value);
        }
        if (values.length == 2) {
            if (values[0] == null || values[1] == null) {
                return null;
            }
            BigDecimal value = new BigDecimal(String.valueOf(values[0]));
            int scale = new BigDecimal(String.valueOf(values[1])).setScale(0, 4).intValue();
            if (scale > 10 || scale < -10) {
                throw new RuntimeException("Parameter out of range");
            }
            if (scale > 0 && value.scale() == 0) {
                return value;
            }
            return DingoNumberRoundOp.round(value, scale);
        }
        return null;
    }

    @Override
    public int typeCode() {
        return -1405464277;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberRoundOp::new;
        }

        public List<String> name() {
            return Arrays.asList("round");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberRoundOp.class.getMethod("round", BigDecimal.class));
                methods.add(DingoNumberRoundOp.class.getMethod("round", BigDecimal.class, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

