/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoCharLengthOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoCharLengthOp.class);
    private static final long serialVersionUID = 5454356467741754567L;

    public DingoCharLengthOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static int charLength(String str) {
        return str.length();
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        if (values[0] == null) {
            return 0;
        }
        return DingoCharLengthOp.charLength((String)values[0]);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoCharLengthOp::new;
        }

        public List<String> name() {
            return Arrays.asList("char_length");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoCharLengthOp.class.getMethod("charLength", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

