/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringConcatOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringConcatOp.class);
    private static final long serialVersionUID = 5454356467741754567L;

    public DingoStringConcatOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String concat(String str1, String str2) {
        return str1 + str2;
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("concat only accept 2 args, current input args: " + values.length);
        }
        String inputStr1 = values[0] == null ? "" : values[0].toString();
        String inputStr2 = values[1] == null ? "" : values[1].toString();
        return DingoStringConcatOp.concat(inputStr1, inputStr2);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringConcatOp::new;
        }

        public List<String> name() {
            return Arrays.asList("concat");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringConcatOp.class.getMethod("concat", String.class, String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

