/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringLTrimOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringLTrimOp.class);
    private static final long serialVersionUID = -8557732786466948967L;

    public DingoStringLTrimOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String trimLeft(String inputStr) {
        int startIndex;
        if (inputStr == null || inputStr.equals("")) {
            return inputStr;
        }
        int endIndex = inputStr.length() - 1;
        for (startIndex = 0; startIndex < inputStr.length() && inputStr.charAt(startIndex) == ' '; ++startIndex) {
        }
        return inputStr.substring(startIndex, endIndex + 1);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String inputStr = (String)values[0];
        return DingoStringLTrimOp.trimLeft(inputStr);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringLTrimOp::new;
        }

        public List<String> name() {
            return Arrays.asList("ltrim");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringLTrimOp.class.getMethod("trimLeft", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

