/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringLeftOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringLeftOp.class);
    private static final long serialVersionUID = 5242457055774200528L;

    public DingoStringLeftOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String leftString(String str, int cnt) {
        if (str == null || str.equals("") || cnt < 0) {
            return "";
        }
        return cnt > str.length() ? str : str.substring(0, cnt);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String str = String.valueOf(values[0]);
        Integer cnt = new BigDecimal(String.valueOf(values[1])).setScale(0, 4).intValue();
        return DingoStringLeftOp.leftString(str, cnt);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringLeftOp::new;
        }

        public List<String> name() {
            return Arrays.asList("left");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringLeftOp.class.getMethod("leftString", String.class, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

