/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringLocateOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringLocateOp.class);
    private static final long serialVersionUID = -3160318945935927347L;

    public DingoStringLocateOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static long locateString(String subString, String inputStr) {
        if (subString.equals("")) {
            return 1L;
        }
        if (inputStr == null || inputStr.equals("")) {
            return 0L;
        }
        return new Long(inputStr.indexOf(subString) + 1);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String subString = (String)values[0];
        String inputStr = (String)values[1];
        return DingoStringLocateOp.locateString(subString, inputStr);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringLocateOp::new;
        }

        public List<String> name() {
            return Arrays.asList("locate");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringLocateOp.class.getMethod("locateString", String.class, String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

