/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringLowerOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringLowerOp.class);
    private static final long serialVersionUID = -3546267408443749483L;

    public DingoStringLowerOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String toLowCase(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return str.toLowerCase();
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        return DingoStringLowerOp.toLowCase((String)values[0]);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringLowerOp::new;
        }

        public List<String> name() {
            return Arrays.asList("lcase");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringLowerOp.class.getMethod("toLowCase", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

