/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringMidOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringMidOp.class);
    private static final long serialVersionUID = 8185618697441684894L;

    public DingoStringMidOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String midString(String inputStr, int startIndex) {
        if (inputStr == null || inputStr.length() == 0) {
            return "";
        }
        if (startIndex < 0) {
            startIndex = startIndex + inputStr.length() + 1;
        }
        if (startIndex - 1 == inputStr.length()) {
            startIndex += 2;
        }
        return inputStr.substring(startIndex - 1);
    }

    public static String midString(String inputStr, int startIndex, int cnt) {
        int endIndex;
        if (inputStr == null || inputStr.length() == 0 || cnt < 0) {
            return "";
        }
        if (startIndex < 0) {
            startIndex = startIndex + inputStr.length() + 1;
        }
        int n = endIndex = startIndex + cnt - 1 > inputStr.length() ? inputStr.length() : startIndex + cnt - 1;
        if (startIndex - 1 == inputStr.length()) {
            startIndex += 2;
        }
        return inputStr.substring(startIndex - 1, endIndex);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String inputStr = (String)values[0];
        BigDecimal decimal = new BigDecimal(values[1].toString());
        Integer startIndex = decimal.setScale(0, 4).intValue();
        if (values.length == 2) {
            return DingoStringMidOp.midString(inputStr, startIndex);
        }
        decimal = new BigDecimal(values[2].toString());
        Integer cnt = decimal.setScale(0, 4).intValue();
        return DingoStringMidOp.midString(inputStr, startIndex, cnt);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringMidOp::new;
        }

        public List<String> name() {
            return Arrays.asList("mid");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringMidOp.class.getMethod("midString", String.class, Integer.TYPE));
                methods.add(DingoStringMidOp.class.getMethod("midString", String.class, Integer.TYPE, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

