/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringRTrimOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringRTrimOp.class);
    private static final long serialVersionUID = -7445709112049015539L;

    public DingoStringRTrimOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String trimRight(String str) {
        int endIndex;
        if (str == null || str.equals("")) {
            return str;
        }
        int startIndex = 0;
        for (endIndex = str.length() - 1; endIndex >= 0 && str.charAt(endIndex) == ' '; --endIndex) {
        }
        return str.substring(startIndex, endIndex + 1);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String str = (String)values[0];
        return DingoStringRTrimOp.trimRight(str);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringRTrimOp::new;
        }

        public List<String> name() {
            return Arrays.asList("rtrim");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringRTrimOp.class.getMethod("trimRight", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

