/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringRepeatOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringRepeatOp.class);
    private static final long serialVersionUID = 7673054922107009329L;

    public DingoStringRepeatOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String repeatString(String inputStr, int times) {
        if (times < 0) {
            return "";
        }
        if (inputStr == null || inputStr.equals("")) {
            return inputStr;
        }
        return String.join((CharSequence)"", Collections.nCopies(times, inputStr));
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String inputStr = (String)values[0];
        int times = new BigDecimal(String.valueOf(values[1])).setScale(0, 4).intValue();
        return DingoStringRepeatOp.repeatString(inputStr, times);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringRepeatOp::new;
        }

        public List<String> name() {
            return Arrays.asList("repeat");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringRepeatOp.class.getMethod("repeatString", String.class, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

