/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringReverseOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringReverseOp.class);
    private static final long serialVersionUID = 2691982562867909922L;

    public DingoStringReverseOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String reverseString(String inputStr) {
        if (inputStr == null || inputStr.equals("")) {
            return inputStr;
        }
        return new StringBuilder(inputStr).reverse().toString();
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String inputStr = (String)values[0];
        return DingoStringReverseOp.reverseString(inputStr);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringReverseOp::new;
        }

        public List<String> name() {
            return Arrays.asList("reverse");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringReverseOp.class.getMethod("reverseString", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

