/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringRightOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringRightOp.class);
    private static final long serialVersionUID = 1043463700086782931L;

    public DingoStringRightOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String rightString(String str, int cnt) {
        if (cnt < 0) {
            return "";
        }
        int length = str.length();
        if (length > cnt) {
            return str.substring(length - cnt, length);
        }
        return str;
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String str = (String)values[0];
        Integer cnt = new BigDecimal(String.valueOf(values[1])).setScale(0, 4).intValue();
        return DingoStringRightOp.rightString(str, cnt);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringRightOp::new;
        }

        public List<String> name() {
            return Arrays.asList("right");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringRightOp.class.getMethod("rightString", String.class, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

