/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringTrimOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringTrimOp.class);
    private static final long serialVersionUID = -4332118553191666565L;

    public DingoStringTrimOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    private static int getLastIndexFromLeft(String inputStr, String trimStr) {
        int result = 0;
        boolean isFound = false;
        for (int index = 0; inputStr.indexOf(trimStr, index) == index && index <= inputStr.length() - 1; index += trimStr.length()) {
            result = index;
            isFound = true;
        }
        if (isFound) {
            return result + trimStr.length();
        }
        return 0;
    }

    private static int getLastIndexFromRight(String inputStr, String trimStr) {
        if (inputStr.length() < trimStr.length()) {
            return inputStr.length() - 1;
        }
        int result = inputStr.length() - 1;
        boolean isFound = false;
        for (int index = inputStr.length() - trimStr.length(); inputStr.lastIndexOf(trimStr, index) == index && index >= 0; index -= trimStr.length()) {
            result = index;
            isFound = true;
        }
        if (isFound) {
            return result;
        }
        return inputStr.length();
    }

    public static String trimStr(String opType, String trimStr, String inputStr) {
        int startIndex = 0;
        int endIndex = inputStr.length();
        switch (opType) {
            case "BOTH": {
                startIndex = DingoStringTrimOp.getLastIndexFromLeft(inputStr, trimStr);
                endIndex = DingoStringTrimOp.getLastIndexFromRight(inputStr, trimStr);
                break;
            }
            case "LEADING": {
                startIndex = DingoStringTrimOp.getLastIndexFromLeft(inputStr, trimStr);
                break;
            }
            case "TRAILING": {
                endIndex = DingoStringTrimOp.getLastIndexFromRight(inputStr, trimStr);
                break;
            }
        }
        if (startIndex >= endIndex) {
            return "";
        }
        return inputStr.substring(startIndex, endIndex);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        if (values.length != 3) {
            return ((String)values[0]).trim();
        }
        String opType = (String)values[0];
        String trimStr = (String)values[1];
        String inputStr = (String)values[2];
        return DingoStringTrimOp.trimStr(opType, trimStr, inputStr);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringTrimOp::new;
        }

        public List<String> name() {
            return Arrays.asList("trim");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringTrimOp.class.getMethod("trimStr", String.class, String.class, String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

