/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringUpperOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoStringUpperOp.class);
    private static final long serialVersionUID = -4349256259193399655L;

    public DingoStringUpperOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String toUpCase(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return str.toUpperCase();
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        return DingoStringUpperOp.toUpCase((String)values[0]);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoStringUpperOp::new;
        }

        public List<String> name() {
            return Arrays.asList("ucase");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoStringUpperOp.class.getMethod("toUpCase", String.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

