/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.string;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.expr.runtime.op.string.RtStringConversionOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoSubStringOp
extends RtStringConversionOp {
    private static final Logger log = LoggerFactory.getLogger(DingoSubStringOp.class);
    private static final long serialVersionUID = 9195218471853466015L;

    public DingoSubStringOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static String subStr(String inputStr, int index, int cnt) {
        if (inputStr == null || inputStr.isEmpty()) {
            return "";
        }
        if (cnt < 0) {
            return "";
        }
        int startIndex = index;
        if (startIndex < 0) {
            startIndex = startIndex + inputStr.length() + 1;
        }
        if (--startIndex + cnt > inputStr.length()) {
            if (startIndex == inputStr.length()) {
                ++startIndex;
            }
            return inputStr.substring(startIndex);
        }
        return inputStr.substring(startIndex, startIndex + cnt);
    }

    @Override
    @Nonnull
    protected Object fun(@Nonnull Object[] values) {
        String inputStr = (String)values[0];
        BigDecimal decimal = new BigDecimal(values[1].toString());
        Integer startIndex = decimal.setScale(0, 4).intValue();
        decimal = new BigDecimal(values[2].toString());
        Integer cnt = decimal.setScale(0, 4).intValue();
        return DingoSubStringOp.subStr(inputStr, startIndex, cnt);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoSubStringOp::new;
        }

        public List<String> name() {
            return Arrays.asList("substring");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoSubStringOp.class.getMethod("subStr", String.class, Integer.TYPE, Integer.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

