/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.EvalEnv;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.exception.NeverRunToHere;
import io.dingodb.expr.runtime.op.RtEnvFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentDateFun
extends RtEnvFun {
    private static final Logger log = LoggerFactory.getLogger(CurrentDateFun.class);
    private static final long serialVersionUID = -6855307131187820249L;

    public CurrentDateFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Override
    protected Object envFun(@Nonnull Object[] values, @Nullable EvalEnv env) {
        return env != null ? DateTimeUtils.currentDate(env.getTimeZone()) : DateTimeUtils.currentDate();
    }

    @Nonnull
    public static Date getCurrentDate() {
        throw new NeverRunToHere("should never be called.");
    }

    @Override
    public int typeCode() {
        return 1087757882;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Arrays.asList("current_date", "curdate");
        }

        public List<Method> methods() {
            ArrayList<Method> methods = new ArrayList<Method>();
            try {
                methods.add(CurrentDateFun.class.getMethod("getCurrentDate", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
            return methods;
        }
    }
}

