/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.EvalEnv;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.exception.NeverRunToHere;
import io.dingodb.expr.runtime.op.RtEnvFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTimeFun
extends RtEnvFun {
    private static final Logger log = LoggerFactory.getLogger(CurrentTimeFun.class);
    private static final long serialVersionUID = -2956287953719703834L;

    public CurrentTimeFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Override
    protected Object envFun(@Nonnull Object[] values, @Nullable EvalEnv env) {
        return env != null ? DateTimeUtils.currentTime(env.getTimeZone()) : DateTimeUtils.currentTime();
    }

    @Nonnull
    public static Time getCurrentTime() {
        throw new NeverRunToHere("should never be called.");
    }

    @Override
    public int typeCode() {
        return 1088242009;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Arrays.asList("current_time", "curtime");
        }

        public List<Method> methods() {
            ArrayList<Method> methods = new ArrayList<Method>();
            try {
                methods.add(CurrentTimeFun.class.getMethod("getCurrentTime", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
            return methods;
        }
    }
}

