/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTimestampFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(CurrentTimestampFun.class);

    public CurrentTimestampFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Nonnull
    public static Timestamp getCurrentTimeStamp() {
        return DateTimeUtils.currentTimestamp();
    }

    @Override
    public int typeCode() {
        return 1252880906;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        return CurrentTimestampFun.getCurrentTimeStamp();
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Arrays.asList("current_timestamp", "now");
        }

        public List<Method> methods() {
            ArrayList<Method> methods = new ArrayList<Method>();
            try {
                methods.add(CurrentTimestampFun.class.getMethod("getCurrentTimeStamp", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
            return methods;
        }
    }
}

