/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDiffFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DateDiffFun.class);
    private static final long serialVersionUID = -8589287644033616224L;

    public DateDiffFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static long dateDiff(Date value0, Date value1) {
        return DateTimeUtils.dateDiff(value0, value1);
    }

    @Override
    public int typeCode() {
        return -2056817302;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        return DateDiffFun.dateDiff((Date)values[0], (Date)values[1]);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("datediff");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DateDiffFun.class.getMethod("dateDiff", Date.class, Date.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

