/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DateFormatFun.class);
    private static final long serialVersionUID = -8131868303444015382L;

    public DateFormatFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date value, @Nonnull String format2) {
        return DateTimeUtils.dateFormat(value, format2);
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date value) {
        return DateTimeUtils.dateFormat(value);
    }

    @Override
    public int typeCode() {
        return 1195259493;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        Date value = (Date)values[0];
        if (values.length < 2) {
            return DateFormatFun.dateFormat(value);
        }
        String format2 = (String)values[1];
        return DateFormatFun.dateFormat(value, format2);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("date_format");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DateFormatFun.class.getMethod("dateFormat", Date.class, String.class));
                methods.add(DateFormatFun.class.getMethod("dateFormat", Date.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

