/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromUnixTimeFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(FromUnixTimeFun.class);
    private static final long serialVersionUID = 9189202071207557600L;

    public FromUnixTimeFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Nonnull
    public static Timestamp fromUnixTime(long seconds) {
        return new Timestamp(seconds * 1000L);
    }

    @Override
    public int typeCode() {
        return 1252880906;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        return FromUnixTimeFun.fromUnixTime(((Number)values[0]).longValue());
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("from_unixtime");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(FromUnixTimeFun.class.getMethod("fromUnixTime", Long.TYPE));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

