/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFormatFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(TimeFormatFun.class);
    private static final long serialVersionUID = 6543488500036739938L;

    public TimeFormatFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Nonnull
    public static String timeFormat(Time value, String format2) {
        return DateTimeUtils.timeFormat(value, format2);
    }

    @Nonnull
    public static String timeFormat(Time value) {
        return DateTimeUtils.timeFormat(value);
    }

    @Override
    public int typeCode() {
        return 1195259493;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        Time value = (Time)values[0];
        if (values.length < 2) {
            return TimeFormatFun.timeFormat(value);
        }
        String format2 = (String)values[1];
        return TimeFormatFun.timeFormat(value, format2);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("time_format");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(TimeFormatFun.class.getMethod("timeFormat", Time.class, String.class));
                methods.add(TimeFormatFun.class.getMethod("timeFormat", Time.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

