/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampFormatFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(TimestampFormatFun.class);
    private static final long serialVersionUID = -4046571111287193650L;

    public TimestampFormatFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Nonnull
    public static String timestampFormat(@Nonnull Timestamp value, @Nonnull String format2) {
        return DateTimeUtils.timestampFormat(value, format2);
    }

    @Nonnull
    public static String timestampFormat(@Nonnull Timestamp value) {
        return DateTimeUtils.timestampFormat(value);
    }

    @Override
    public int typeCode() {
        return 1195259493;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        Timestamp value = (Timestamp)values[0];
        if (values.length < 2) {
            return TimestampFormatFun.timestampFormat(value);
        }
        String format2 = (String)values[1];
        return TimestampFormatFun.timestampFormat(value, format2);
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("timestamp_format");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(TimestampFormatFun.class.getMethod("timestampFormat", Timestamp.class, String.class));
                methods.add(TimestampFormatFun.class.getMethod("timestampFormat", Timestamp.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

