/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.time;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixTimestampFun
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(UnixTimestampFun.class);

    public UnixTimestampFun(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static long unixTimestamp() {
        return UnixTimestampFun.unixTimestamp(DateTimeUtils.currentTimestamp());
    }

    public static long unixTimestamp(@Nonnull Timestamp value) {
        return Math.floorDiv(value.getTime(), 1000L);
    }

    @Override
    public int typeCode() {
        return 398795216;
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        return values.length > 0 ? UnixTimestampFun.unixTimestamp((Timestamp)values[0]) : UnixTimestampFun.unixTimestamp();
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public List<String> name() {
            return Collections.singletonList("unix_timestamp");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(UnixTimestampFun.class.getMethod("unixTimestamp", new Class[0]));
                methods.add(UnixTimestampFun.class.getMethod("unixTimestamp", Timestamp.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

