/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtils.class);
    public static final long ONE_DAY_IN_MILLI = 86400000L;
    public static final DateTimeFormatter STD_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter STD_TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final DateTimeFormatter STD_DATETIME_FORMATTER = new DateTimeFormatterBuilder().append(STD_DATE_FORMATTER).appendLiteral(' ').append(STD_TIME_FORMATTER).toFormatter();
    private static final String[] DATE_FORMATTER_PATTERNS = new String[]{"%Y-%m-%d", "%Y/%m/%d", "%Y.%m.%d", "%Y%m%d"};
    private static final String[] TIME_FORMATTER_PATTERNS = new String[]{"%H:%i:%s", "%H%i%s"};
    private static final String[] DATETIME_FORMATTER_PATTERNS = new String[]{"%Y-%m-%d %H:%i:%s", "%Y/%m/%d %H:%i:%s", "%Y.%m.%d %H:%i:%s", "%Y%m%d%H%i%s"};
    private static final DateTimeFormatter[] DATE_FORMATTERS = new DateTimeFormatter[]{DateTimeUtils.dateFormatterWithSeparator('-'), DateTimeUtils.dateFormatterWithSeparator('/'), DateTimeUtils.dateFormatterWithSeparator('.'), new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter().withResolverStyle(ResolverStyle.STRICT)};
    private static final DateTimeFormatter[] TIME_FORMATTERS = new DateTimeFormatter[]{new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter().withResolverStyle(ResolverStyle.STRICT), new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter().withResolverStyle(ResolverStyle.STRICT)};
    private static final DateTimeFormatter[] DATETIME_FORMATTERS = new DateTimeFormatter[]{DateTimeUtils.concatDateTimeFormatter(DATE_FORMATTERS[0], TIME_FORMATTERS[0], Character.valueOf(' ')), DateTimeUtils.concatDateTimeFormatter(DATE_FORMATTERS[1], TIME_FORMATTERS[0], Character.valueOf(' ')), DateTimeUtils.concatDateTimeFormatter(DATE_FORMATTERS[2], TIME_FORMATTERS[0], Character.valueOf(' ')), DateTimeUtils.concatDateTimeFormatter(DATE_FORMATTERS[3], TIME_FORMATTERS[1], null)};

    private DateTimeUtils() {
    }

    @Nonnull
    private static DateTimeFormatter dateFormatterWithSeparator(char sep) {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral(sep).appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral(sep).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    }

    @Nonnull
    private static DateTimeFormatter concatDateTimeFormatter(DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter, Character sep) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(dateFormatter);
        if (sep != null) {
            builder.appendLiteral(' ');
        }
        builder.append(timeFormatter);
        return builder.toFormatter().withResolverStyle(ResolverStyle.STRICT);
    }

    @Nullable
    public static Date parseDate(@Nonnull String value) {
        if (value.isEmpty()) {
            return null;
        }
        for (DateTimeFormatter dtf : DATE_FORMATTERS) {
            try {
                LocalDateTime t = LocalDate.parse(value, dtf).atStartOfDay();
                return new Date(t.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date string \"" + value + "\", supported formats are [" + String.join((CharSequence)", ", DATE_FORMATTER_PATTERNS) + "].");
    }

    @Nullable
    public static Time parseTime(@Nonnull String value) {
        if (value.isEmpty()) {
            return null;
        }
        for (DateTimeFormatter dtf : TIME_FORMATTERS) {
            try {
                LocalDateTime t = LocalTime.parse(value, dtf).atDate(LocalDate.of(1970, 1, 1));
                return new Time(t.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse time string \"" + value + "\", supported formats are [" + String.join((CharSequence)", ", TIME_FORMATTER_PATTERNS) + "].");
    }

    @Nullable
    public static Timestamp parseTimestamp(@Nonnull String value) {
        if (value.isEmpty()) {
            return null;
        }
        for (DateTimeFormatter dtf : DATETIME_FORMATTERS) {
            try {
                LocalDateTime t = LocalDateTime.parse(value, dtf);
                return Timestamp.valueOf(t);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse timestamp string \"" + value + "\", supported formats are [" + String.join((CharSequence)", ", DATETIME_FORMATTER_PATTERNS) + "].");
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date value, @Nonnull DateTimeFormatter formatter) {
        return Instant.ofEpochMilli(value.getTime()).atZone(ZoneOffset.UTC).format(formatter);
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date value, @Nonnull String format2) {
        return DateTimeUtils.dateFormat(value, DateTimeFormatter.ofPattern(DateTimeUtils.convertFormat(format2)).withResolverStyle(ResolverStyle.STRICT));
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date value) {
        return DateTimeUtils.dateFormat(value, STD_DATE_FORMATTER);
    }

    @Nonnull
    public static String timeFormat(@Nonnull Time value, @Nonnull DateTimeFormatter formatter) {
        return Instant.ofEpochMilli(value.getTime()).atZone(ZoneOffset.UTC).format(formatter);
    }

    @Nonnull
    public static String timeFormat(@Nonnull Time value, @Nonnull String format2) {
        return DateTimeUtils.timeFormat(value, DateTimeFormatter.ofPattern(DateTimeUtils.convertFormat(format2)).withResolverStyle(ResolverStyle.STRICT));
    }

    @Nonnull
    public static String timeFormat(@Nonnull Time value) {
        return DateTimeUtils.timeFormat(value, STD_TIME_FORMATTER);
    }

    @Nonnull
    public static String timestampFormat(@Nonnull Timestamp value, @Nonnull DateTimeFormatter formatter) {
        return value.toLocalDateTime().format(formatter);
    }

    @Nonnull
    public static String timestampFormat(@Nonnull Timestamp timestamp, @Nonnull String format2) {
        return DateTimeUtils.timestampFormat(timestamp, DateTimeFormatter.ofPattern(DateTimeUtils.convertFormat(format2)).withResolverStyle(ResolverStyle.STRICT));
    }

    @Nonnull
    public static String timestampFormat(@Nonnull Timestamp value) {
        return DateTimeUtils.timestampFormat(value, STD_DATETIME_FORMATTER);
    }

    @Nonnull
    public static Date currentDate() {
        return DateTimeUtils.currentDate(TimeZone.getDefault());
    }

    @Nonnull
    public static Date currentDate(@Nonnull TimeZone timeZone) {
        long millis = System.currentTimeMillis();
        millis = Math.floorDiv(millis + (long)timeZone.getOffset(millis), 86400000L) * 86400000L;
        return new Date(millis);
    }

    @Nonnull
    public static Time currentTime() {
        return DateTimeUtils.currentTime(TimeZone.getDefault());
    }

    @Nonnull
    public static Time currentTime(@Nonnull TimeZone timeZone) {
        long millis = System.currentTimeMillis();
        millis = Math.floorMod(millis + (long)timeZone.getOffset(millis), 86400000L);
        return new Time(millis);
    }

    @Nonnull
    public static Timestamp currentTimestamp() {
        long millis = System.currentTimeMillis();
        return new Timestamp(millis);
    }

    private static LocalDate localDateOf(@Nonnull Date value) {
        return Instant.ofEpochMilli(value.getTime()).atZone(ZoneOffset.UTC).toLocalDate();
    }

    public static long dateDiff(@Nonnull Date value0, @Nonnull Date value1) {
        return DateTimeUtils.localDateOf(value0).toEpochDay() - DateTimeUtils.localDateOf(value1).toEpochDay();
    }

    @Nonnull
    static String convertFormat(@Nonnull String mysqlFormat) {
        StringBuilder builder = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(mysqlFormat);
        boolean literalStarted = false;
        char ch = it.first();
        while (ch != '\uffff') {
            block18: {
                block17: {
                    if (ch != '%') break block17;
                    ch = it.next();
                    String fmt = null;
                    switch (ch) {
                        case 'Y': {
                            fmt = "uuuu";
                            break;
                        }
                        case 'm': {
                            fmt = "MM";
                            break;
                        }
                        case 'd': {
                            fmt = "dd";
                            break;
                        }
                        case 'H': {
                            fmt = "HH";
                            break;
                        }
                        case 'i': {
                            fmt = "mm";
                            break;
                        }
                        case 'S': 
                        case 's': {
                            fmt = "ss";
                            break;
                        }
                        case 'T': {
                            fmt = "HH:mm:ss";
                            break;
                        }
                        case 'f': {
                            fmt = "SSS";
                            break;
                        }
                        case '\uffff': {
                            break block18;
                        }
                        default: {
                            if (!literalStarted) {
                                builder.append('\'');
                                literalStarted = true;
                            }
                            builder.append(ch);
                        }
                    }
                    if (fmt != null) {
                        if (literalStarted) {
                            builder.append('\'');
                            literalStarted = false;
                        }
                        builder.append(fmt);
                    }
                    break block18;
                }
                if (!literalStarted) {
                    builder.append('\'');
                    literalStarted = true;
                }
                builder.append(ch);
            }
            ch = it.next();
        }
        if (literalStarted) {
            builder.append('\'');
        }
        return builder.toString();
    }

    @Nonnull
    public static String toUtcString(java.util.Date value) {
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dtf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dtf.format(value);
    }
}

