/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net;

import io.dingodb.common.codec.PrimitiveCodec;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Message {
    public static final String EMPTY_TAG = "";
    public static final String API_OK = "API_OK";
    public static final String API_ERROR = "API_ERROR";
    public static final String API_CANCEL = "API_CANCEL";
    public static final String FILE_TRANSFER = "FILE_TRANSFER";
    public static final Message EMPTY = new Message("", new byte[0]);
    private final String tag;
    private final byte[] content;

    public String tag() {
        return this.tag;
    }

    public byte[] content() {
        return this.content;
    }

    public byte[] encode() {
        byte[] tag = PrimitiveCodec.encodeString(this.tag);
        byte[] result = new byte[tag.length + this.content.length];
        System.arraycopy(tag, 0, result, 0, tag.length);
        System.arraycopy(this.content, 0, result, tag.length, this.content.length);
        return result;
    }

    public static Message decode(ByteBuffer buffer) {
        String tag = PrimitiveCodec.readString(buffer);
        byte[] content = new byte[buffer.remaining()];
        buffer.get(content);
        return new Message(tag, content);
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getTag() {
        return this.tag;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        return Arrays.equals(this.getContent(), other.getContent());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        return result;
    }

    public Message(String tag, byte[] content) {
        this.tag = tag;
        this.content = content;
    }

    public static class MessageBuilder {
        private String tag;
        private byte[] content;

        MessageBuilder() {
        }

        public MessageBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public MessageBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        public Message build() {
            return new Message(this.tag, this.content);
        }

        public String toString() {
            return "Message.MessageBuilder(tag=" + this.tag + ", content=" + Arrays.toString(this.content) + ")";
        }
    }
}

