/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net;

import io.dingodb.common.codec.PrimitiveCodec;
import io.dingodb.common.error.DingoError;
import io.dingodb.common.error.DingoException;
import io.dingodb.common.error.FormattingError;
import io.dingodb.net.Message;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum NetError implements FormattingError
{
    OK(0, "OK, no error."),
    HANDSHAKE(31001, "Handshake failed.", "Handshake failed. Reason: [%s]"),
    OPEN_CHANNEL_TIME_OUT(31002, "Open channel time out.", "Open channel time out."),
    OPEN_CHANNEL_INTERRUPT(31003, "Open channel interrupt", "Open channel interrupt"),
    OPEN_CONNECTION_TIME_OUT(31002, "Open connection time out.", "Open connection time out, remote [%s]"),
    OPEN_CONNECTION_INTERRUPT(31003, "Open connection interrupt", "Open connection interrupt, remote [%s]"),
    OPEN_CHANNEL_BUSY(31004, "Open channel busy", "Open channel busy"),
    EXEC(32001, "Execute error", "Exec %s error, thread: [%s], message: [%s]."),
    EXEC_INTERRUPT(32002, "Exec interrupted error.", "Exec %s interrupted, thread: [%s], message: [%s]."),
    EXEC_TIMEOUT(32003, "Execute timeout.", "Exec %s timeout, thread: [%s], message: [%s]."),
    API_NOT_FOUND(32004, "Api not found.", "Api %s not found."),
    UNKNOWN(39000, "Unknown.", "Unknown error, message: [%s]"),
    IO(39001, "IO error, please check log.", "IO error, message: [%s]");

    private final int code;
    private final String info;
    private final String format;
    private static Map<Integer, NetError> valueOfCache;

    private NetError(int code, String info) {
        this.code = code;
        this.info = info;
        this.format = info;
        NetError.addCache(code, this);
    }

    private NetError(int code, String info, String format2) {
        this.code = code;
        this.info = info;
        this.format = format2;
        NetError.addCache(code, this);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return DingoError.toString(this);
    }

    public Message message() {
        return Message.builder().content(PrimitiveCodec.encodeZigZagInt(this.getCode())).build();
    }

    public static Message message(DingoException err) {
        return Message.builder().content(PrimitiveCodec.encodeZigZagInt(err.getCode())).build();
    }

    private static void addCache(int code, NetError error2) {
        if (valueOfCache == null) {
            valueOfCache = new HashMap<Integer, NetError>();
        }
        valueOfCache.put(code, error2);
    }

    public static FormattingError valueOf(Integer code) {
        if (code == NetError.OK.code) {
            return null;
        }
        return valueOfCache.computeIfAbsent(code, k -> Arrays.stream(NetError.values()).filter(c -> c.code == code).findAny().orElse(null));
    }

    public static FormattingError valueOf(byte[] bytes) {
        return NetError.valueOf(PrimitiveCodec.readZigZagInt(bytes));
    }

    public static FormattingError valueOf(ByteBuffer buffer) {
        return NetError.valueOf(PrimitiveCodec.readZigZagInt(buffer));
    }
}

