/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty;

import io.dingodb.common.config.DingoConfiguration;

public class NetServiceConfiguration {
    public static final int MIN_HEARTBEAT = 3;
    public static final int MIN_QUEUE_CAPACITY = Runtime.getRuntime().availableProcessors() * 2;
    public static final String HEARTBEAT = "heartbeat";
    public static final NetServiceConfiguration INSTANCE;
    private Integer heartbeat;
    private String host;
    private Integer apiTimeout;

    public static NetServiceConfiguration instance() {
        return INSTANCE;
    }

    public static Integer heartbeat() {
        return NetServiceConfiguration.INSTANCE.heartbeat;
    }

    public static String host() {
        return NetServiceConfiguration.INSTANCE.host;
    }

    public static Integer apiTimeout() {
        return NetServiceConfiguration.INSTANCE.apiTimeout == null ? 30 : NetServiceConfiguration.INSTANCE.apiTimeout;
    }

    public static void resetAllTimeout(int timeout) {
        NetServiceConfiguration.INSTANCE.apiTimeout = timeout;
        NetServiceConfiguration.INSTANCE.heartbeat = timeout;
    }

    public Integer getHeartbeat() {
        return this.heartbeat;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getApiTimeout() {
        return this.apiTimeout;
    }

    static {
        try {
            DingoConfiguration dingoConfiguration = DingoConfiguration.instance();
            if (dingoConfiguration == null) {
                INSTANCE = new NetServiceConfiguration();
                NetServiceConfiguration.INSTANCE.host = "127.0.0.1";
            } else {
                dingoConfiguration.setNet(NetServiceConfiguration.class);
                INSTANCE = (NetServiceConfiguration)dingoConfiguration.getNet();
                if (NetServiceConfiguration.INSTANCE.host == null) {
                    NetServiceConfiguration.INSTANCE.host = dingoConfiguration.getHost();
                }
            }
            if (NetServiceConfiguration.INSTANCE.heartbeat == null || NetServiceConfiguration.INSTANCE.heartbeat < 3) {
                NetServiceConfiguration.INSTANCE.heartbeat = 3;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

