/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty;

import io.dingodb.common.Location;
import io.dingodb.common.util.Parameters;
import io.dingodb.common.util.StackTraces;
import io.dingodb.net.MessageListener;
import io.dingodb.net.MessageListenerProvider;
import io.dingodb.net.NetService;
import io.dingodb.net.api.ApiRegistry;
import io.dingodb.net.netty.NetServiceConfiguration;
import io.dingodb.net.netty.api.ApiRegistryImpl;
import io.dingodb.net.netty.channel.Channel;
import io.dingodb.net.netty.connection.ConnectionManager;
import io.dingodb.net.netty.handler.TagMessageHandler;
import io.dingodb.net.netty.listener.PortListener;
import io.dingodb.net.netty.listener.impl.NettyServer;
import io.dingodb.net.service.FileTransferService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyNetService
implements NetService {
    private static final Logger log = LoggerFactory.getLogger(NettyNetService.class);
    private final Map<Integer, PortListener> portListeners;
    private final ConnectionManager connectionManager;
    private final String hostname = NetServiceConfiguration.host();

    protected NettyNetService() {
        this.connectionManager = new ConnectionManager();
        this.portListeners = new ConcurrentHashMap<Integer, PortListener>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                log.error("Close connection error", e);
            }
        }));
    }

    @Override
    public void listenPort(int port) throws Exception {
        if (this.portListeners.containsKey(port)) {
            return;
        }
        NettyServer server = NettyServer.builder().port(port).connectionManager(this.connectionManager).build();
        server.init();
        server.start();
        this.portListeners.put(port, server);
        log.info("Start listening {}.", (Object)port);
        FileTransferService.getDefault();
    }

    @Override
    public void cancelPort(int port) throws Exception {
        this.portListeners.remove(port).close();
    }

    @Override
    public ApiRegistry apiRegistry() {
        return ApiRegistryImpl.instance();
    }

    @Override
    public Channel newChannel(Location location) {
        return this.newChannel(location, true);
    }

    @Override
    public Channel newChannel(Location location, boolean keepAlive) {
        return this.connectionManager.getOrOpenConnection(location).newChannel(keepAlive);
    }

    @Override
    public void setMessageListenerProvider(String tag, MessageListenerProvider listenerProvider) {
        Parameters.nonNull(tag, "tag");
        Parameters.nonNull(listenerProvider, "listener provider");
        if (log.isDebugEnabled()) {
            log.debug("Register message listener provider, tag: [{}], listener provider class: [{}], caller: [{}]", tag, listenerProvider.getClass().getName(), StackTraces.stack(2));
        }
        TagMessageHandler.INSTANCE.setTagListenerProvider(tag, listenerProvider);
    }

    @Override
    public void unsetMessageListenerProvider(String tag) {
        Parameters.nonNull(tag, "tag");
        if (log.isDebugEnabled()) {
            log.debug("Unregister message listener provider, tag: [{}], caller: [{}]", (Object)tag, (Object)StackTraces.stack(2));
        }
        TagMessageHandler.INSTANCE.unsetTagListenerProvider(tag);
    }

    @Override
    public void registerTagMessageListener(String tag, MessageListener listener) {
        Parameters.nonNull(tag, "tag");
        Parameters.nonNull(listener, "listener");
        if (log.isDebugEnabled()) {
            log.info("Register message listener, tag: [{}], listener class: [{}], caller: [{}]", tag, listener.getClass().getName(), StackTraces.stack(2));
        }
        TagMessageHandler.INSTANCE.addTagListener(tag, listener);
    }

    @Override
    public void unregisterTagMessageListener(String tag, MessageListener listener) {
        Parameters.nonNull(tag, "tag");
        Parameters.nonNull(listener, "listener");
        if (log.isDebugEnabled()) {
            log.debug("Unregister message listener, tag: [{}], listener class: [{}], caller: [{}]", tag, listener.getClass().getName(), StackTraces.stack(2));
        }
        TagMessageHandler.INSTANCE.removeTagListener(tag, listener);
    }

    @Override
    public void close() throws Exception {
        for (PortListener listener : this.portListeners.values()) {
            listener.close();
        }
        this.connectionManager.close();
    }

    public Map<Integer, PortListener> getPortListeners() {
        return this.portListeners;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getHostname() {
        return this.hostname;
    }
}

