/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.api;

import io.dingodb.common.Location;
import io.dingodb.common.codec.PrimitiveCodec;
import io.dingodb.common.codec.ProtostuffCodec;
import io.dingodb.net.MessageListener;
import io.dingodb.net.api.annotation.ApiDeclaration;
import io.dingodb.net.netty.channel.Channel;
import io.dingodb.net.netty.packet.Type;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public interface ApiProxy<T>
extends InvocationHandler {
    public Channel channel();

    public T defined();

    public int timeout();

    public void invoke(Channel var1, ByteBuf var2, CompletableFuture<Object> var3) throws Exception;

    @Override
    default public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ApiDeclaration declaration = method.getAnnotation(ApiDeclaration.class);
        if (declaration == null) {
            return this.invoke(method, args);
        }
        String name = declaration.name();
        if (name.isEmpty()) {
            name = method.toGenericString();
        }
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Channel channel = this.channel();
        try {
            channel.setMessageListener(ApiProxy.callHandler(future));
            channel.setCloseListener(ch -> ApiProxy.closeListener(channel, future));
            byte[] nameB = PrimitiveCodec.encodeString(name);
            byte[] content = ProtostuffCodec.write(args);
            this.invoke(channel, channel.buffer(Type.API, nameB.length + content.length).writeBytes(nameB).writeBytes(content), future);
        }
        catch (Exception e) {
            if (channel == null) {
                future.complete(e);
            }
            ApiProxy.completeExceptionally(future, e, channel.remoteLocation());
        }
        if (method.getReturnType().isInstance(future)) {
            return future;
        }
        int timeout = this.timeout();
        return timeout == 0 ? future.join() : future.get(timeout, TimeUnit.SECONDS);
    }

    default public Object invoke(Method method, Object[] args) throws Exception {
        T defined = this.defined();
        if (defined == null) {
            throw new UnsupportedOperationException();
        }
        return method.invoke(defined, args);
    }

    public static MessageListener callHandler(CompletableFuture<Object> future) {
        return (message, ch) -> {
            try {
                if (message.tag().equals("API_OK")) {
                    future.complete(ProtostuffCodec.read(message.content()));
                } else {
                    ApiProxy.completeExceptionally(future, (Throwable)ProtostuffCodec.read(message.content()), ch.remoteLocation());
                }
            }
            catch (Exception e) {
                ApiProxy.completeExceptionally(future, e, ch.remoteLocation());
            }
        };
    }

    public static void closeListener(Channel channel, CompletableFuture<Object> future) {
        if (!future.isDone()) {
            ApiProxy.completeExceptionally(future, new RuntimeException("Channel closed"), channel.remoteLocation());
        }
    }

    public static void completeExceptionally(CompletableFuture<?> future, Throwable throwable, Location location) {
        future.completeExceptionally(new InvocationTargetException(throwable, String.format("Invoke on [%s] failed.", location.getUrl())));
    }
}

