/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.api;

import io.dingodb.common.concurrent.Executors;
import io.dingodb.net.Message;
import io.dingodb.net.netty.api.ApiProxy;
import io.dingodb.net.netty.channel.Channel;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedChannelProxy<T>
implements ApiProxy<T> {
    private static final Logger log = LoggerFactory.getLogger(FixedChannelProxy.class);
    private final Channel channel;
    private final T defined;
    private final int timeout;

    public FixedChannelProxy(Channel channel) {
        this(channel, null);
    }

    public FixedChannelProxy(Channel channel, T defined) {
        this(channel, defined, 0);
    }

    public FixedChannelProxy(Channel channel, T defined, int timeout) {
        this.channel = channel;
        this.defined = defined;
        this.timeout = timeout;
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return ApiProxy.super.invoke(proxy, method, args);
    }

    @Override
    public void invoke(Channel ch, ByteBuf buffer, CompletableFuture<Object> future) throws InterruptedException {
        future.whenCompleteAsync((r, e) -> {
            if (e instanceof CancellationException) {
                ch.send(new Message("API_CANCEL", Message.EMPTY.content()));
            }
        }, Executors.executor("cancel-api-invoke"));
        ch.send(buffer);
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public T defined() {
        return this.defined;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }
}

