/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.api;

import io.dingodb.common.codec.ProtostuffCodec;
import io.dingodb.net.Message;
import io.dingodb.net.api.annotation.ApiDeclaration;
import io.dingodb.net.error.ApiTerminateException;
import io.dingodb.net.netty.Versions;
import io.dingodb.net.netty.channel.Channel;
import io.dingodb.net.netty.packet.Command;

public interface HandshakeApi {
    public static final HandshakeApi INSTANCE = new HandshakeApi(){};
    public static final RuntimeException VERSION_EXCEPTION = new RuntimeException("Version not support.");

    @ApiDeclaration
    default public Command handshake(Channel channel, Handshake handshake) {
        if (Versions.checkCode(handshake.code, 0) && Versions.currentVersion() == handshake.version) {
            return Command.ACK;
        }
        channel.send(new Message("API_ERROR", ProtostuffCodec.write(VERSION_EXCEPTION)), true);
        channel.connection().close();
        throw new ApiTerminateException("Handshake failed, the version [%s] not support.", handshake.version);
    }

    public static class Handshake {
        byte[] code;
        byte version;
        public static final Handshake INSTANCE = new Handshake(Versions.MAGIC_CODE, Versions.currentVersion());

        public Handshake(byte[] code, byte version) {
            this.code = code;
            this.version = version;
        }
    }
}

