/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.api;

import io.dingodb.common.Location;
import io.dingodb.common.concurrent.Executors;
import io.dingodb.net.Message;
import io.dingodb.net.netty.NettyNetService;
import io.dingodb.net.netty.NettyNetServiceProvider;
import io.dingodb.net.netty.api.ApiProxy;
import io.dingodb.net.netty.channel.Channel;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomChannelProxy<T>
implements ApiProxy<T> {
    private static final Logger log = LoggerFactory.getLogger(RandomChannelProxy.class);
    private static final NettyNetService netService = NettyNetServiceProvider.NET_SERVICE_INSTANCE;
    private final Supplier<Location> locationSupplier;
    private final T defined;
    private final int timeout;

    public RandomChannelProxy(Supplier<Location> locationSupplier) {
        this(locationSupplier, null);
    }

    public RandomChannelProxy(Supplier<Location> locationSupplier, T defined) {
        this(locationSupplier, defined, 0);
    }

    public RandomChannelProxy(Supplier<Location> locationSupplier, T defined, int timeout) {
        this.locationSupplier = locationSupplier;
        this.defined = defined;
        this.timeout = timeout;
    }

    @Override
    public Channel channel() {
        return netService.newChannel(this.locationSupplier.get());
    }

    @Override
    public void invoke(Channel ch, ByteBuf buffer, CompletableFuture<Object> future) throws Exception {
        future.whenCompleteAsync((r, e) -> {
            if (e instanceof CancellationException) {
                ch.send(new Message("API_CANCEL", Message.EMPTY.content()));
            }
            try {
                ch.close();
            }
            catch (Exception ex) {
                log.error("Close channel error, address: [{}].", (Object)ch.remoteLocation(), (Object)ex);
            }
        }, Executors.executor("on-invoke-complete"));
        ch.send(buffer);
    }

    @Override
    public T defined() {
        return this.defined;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }
}

