/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.connection;

import io.dingodb.common.Location;
import io.dingodb.common.concurrent.Executors;
import io.dingodb.net.Channel;
import io.dingodb.net.netty.NetServiceConfiguration;
import io.dingodb.net.netty.api.ApiRegistryImpl;
import io.dingodb.net.netty.api.HandshakeApi;
import io.dingodb.net.netty.connection.Connection;
import io.dingodb.net.netty.handler.ExceptionHandler;
import io.dingodb.net.netty.handler.MessageHandler;
import io.dingodb.net.netty.packet.Command;
import io.dingodb.net.netty.packet.Type;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection
extends Connection {
    private static final Logger log = LoggerFactory.getLogger(ClientConnection.class);
    protected Bootstrap bootstrap;
    protected EventLoopGroup eventLoopGroup;

    public ClientConnection(Location location) {
        super(location, null);
    }

    public void connect() throws InterruptedException {
        this.bootstrap = new Bootstrap();
        this.eventLoopGroup = new NioEventLoopGroup(0, Executors.executor(this.remoteLocation.getUrl() + "/connection"));
        ((Bootstrap)((Bootstrap)this.bootstrap.channel(NioSocketChannel.class)).group(this.eventLoopGroup)).remoteAddress(this.remoteLocation.toSocketAddress()).handler(this.channelInitializer());
        this.bootstrap.connect().sync().await();
        this.handshake();
    }

    private ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ClientConnection.this.socketChannel = ch;
                ch.pipeline().addLast(new MessageHandler(ClientConnection.this)).addLast(new IdleStateHandler(NetServiceConfiguration.heartbeat().intValue(), 0L, 0L, TimeUnit.SECONDS)).addLast(new ExceptionHandler(ClientConnection.this));
            }
        };
    }

    protected void handshake() throws InterruptedException {
        ApiRegistryImpl.instance().proxy(HandshakeApi.class, (Channel)this.channel, (int)NetServiceConfiguration.heartbeat()).handshake(null, HandshakeApi.Handshake.INSTANCE);
        log.info("Connection open, remote: [{}]", (Object)this.remoteLocation.getUrl());
        InetSocketAddress localAddress = this.socketChannel.localAddress();
        this.localLocation = new Location(localAddress.getHostName(), localAddress.getPort());
        Executors.scheduleWithFixedDelayAsync(String.format("%s-heartbeat", this.remoteLocation), this::sendHeartbeat, 0L, 1L, TimeUnit.SECONDS);
    }

    private void sendHeartbeat() {
        this.channel.sendAsync(this.channel.buffer(Type.COMMAND, 1).writeByte(Command.PING.code()));
    }

    @Override
    protected Map<Long, io.dingodb.net.netty.channel.Channel> createChannels() {
        return new ConcurrentHashMap<Long, io.dingodb.net.netty.channel.Channel>();
    }

    @Override
    protected String channelName(String url, long id) {
        return String.format("<%s/%s/client>", url, id);
    }

    @Override
    public void receive(ByteBuffer message) {
        if (message == null) {
            return;
        }
        long channelId = message.getLong();
        io.dingodb.net.netty.channel.Channel channel = this.getChannel(channelId);
        if (channel == null) {
            log.error("Receive message, channel id is [{}], but not have channel.", (Object)channelId);
            return;
        }
        channel.receive(message);
    }

    @Override
    public void close() {
        super.close();
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
        log.info("Connection close, remote: [{}].", (Object)this.remoteLocation.getUrl());
    }
}

