/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.connection;

import io.dingodb.common.Location;
import io.dingodb.common.concurrent.LinkedRunner;
import io.dingodb.common.config.DingoConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Connection {
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    protected final Map<Long, io.dingodb.net.netty.channel.Channel> channels = this.createChannels();
    protected final AtomicLong channelIdSeq = new AtomicLong(0L);
    protected final io.dingodb.net.netty.channel.Channel channel;
    protected Location remoteLocation;
    protected Location localLocation;
    protected SocketChannel socketChannel;

    public Connection(Location remoteLocation, Location localLocation) {
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        this.channel = this.createChannel(0L);
        this.channels.put(0L, this.channel);
    }

    protected abstract Map<Long, io.dingodb.net.netty.channel.Channel> createChannels();

    public abstract void receive(ByteBuffer var1);

    public Location localLocation() {
        return DingoConfiguration.instance() == null ? this.localLocation : DingoConfiguration.location();
    }

    public void send(ByteBuf message) throws InterruptedException {
        this.socketChannel.writeAndFlush(message).await();
    }

    public void sendAsync(ByteBuf message) {
        this.socketChannel.writeAndFlush(message);
    }

    protected abstract String channelName(String var1, long var2);

    protected io.dingodb.net.netty.channel.Channel createChannel(long channelId) {
        return new io.dingodb.net.netty.channel.Channel(channelId, this, new LinkedRunner(this.channelName(this.remoteLocation.getUrl(), channelId)), this.channels::remove);
    }

    public io.dingodb.net.netty.channel.Channel newChannel(boolean keepAlive) {
        return this.channels.computeIfAbsent(this.channelIdSeq.incrementAndGet(), this::createChannel);
    }

    public io.dingodb.net.netty.channel.Channel getChannel(long channelId) {
        return this.channels.get(channelId);
    }

    public void close() {
        this.channel.shutdown();
        this.channels.values().forEach(io.dingodb.net.netty.channel.Channel::shutdown);
        this.channels.clear();
        if (this.socketChannel.isActive()) {
            this.socketChannel.disconnect();
        }
    }

    public io.dingodb.net.netty.channel.Channel channel() {
        return this.channel;
    }

    public Location remoteLocation() {
        return this.remoteLocation;
    }

    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    public ServerSocketChannel parent() {
        return this.socketChannel().parent();
    }

    public SocketChannelConfig config() {
        return this.socketChannel().config();
    }

    public InetSocketAddress localAddress() {
        return this.socketChannel().localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return this.socketChannel().remoteAddress();
    }

    public boolean isInputShutdown() {
        return this.socketChannel().isInputShutdown();
    }

    public ChannelFuture shutdownInput() {
        return this.socketChannel().shutdownInput();
    }

    public ChannelFuture shutdownInput(ChannelPromise arg0) {
        return this.socketChannel().shutdownInput(arg0);
    }

    public boolean isOutputShutdown() {
        return this.socketChannel().isOutputShutdown();
    }

    public ChannelFuture shutdownOutput() {
        return this.socketChannel().shutdownOutput();
    }

    public ChannelFuture shutdownOutput(ChannelPromise arg0) {
        return this.socketChannel().shutdownOutput(arg0);
    }

    public boolean isShutdown() {
        return this.socketChannel().isShutdown();
    }

    public ChannelFuture shutdown() {
        return this.socketChannel().shutdown();
    }

    public ChannelFuture shutdown(ChannelPromise arg0) {
        return this.socketChannel().shutdown(arg0);
    }

    public ChannelId id() {
        return this.socketChannel().id();
    }

    public EventLoop eventLoop() {
        return this.socketChannel().eventLoop();
    }

    public boolean isOpen() {
        return this.socketChannel().isOpen();
    }

    public boolean isRegistered() {
        return this.socketChannel().isRegistered();
    }

    public boolean isActive() {
        return this.socketChannel().isActive();
    }

    public ChannelMetadata metadata() {
        return this.socketChannel().metadata();
    }

    public ChannelFuture closeFuture() {
        return this.socketChannel().closeFuture();
    }

    public boolean isWritable() {
        return this.socketChannel().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.socketChannel().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.socketChannel().bytesBeforeWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.socketChannel().unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.socketChannel().pipeline();
    }

    public ByteBufAllocator alloc() {
        return this.socketChannel().alloc();
    }

    public int compareTo(Channel arg0) {
        return this.socketChannel().compareTo(arg0);
    }
}

