/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.connection;

import io.dingodb.common.Location;
import io.dingodb.net.NetError;
import io.dingodb.net.netty.connection.ClientConnection;
import io.dingodb.net.netty.connection.Connection;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final Map<Location, Connection> connections = new ConcurrentHashMap<Location, Connection>(8);

    public Connection open(Location location) {
        if (this.connections.containsKey(location)) {
            throw new UnsupportedOperationException();
        }
        ClientConnection connection = new ClientConnection(location);
        try {
            connection.connect();
        }
        catch (InterruptedException e) {
            NetError.OPEN_CONNECTION_INTERRUPT.throwFormatError(location);
        }
        catch (Exception e) {
            connection.close();
            throw e;
        }
        connection.socketChannel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.onClose(connection)));
        return connection;
    }

    public Connection getConnection(Location location) {
        return this.connections.get(location);
    }

    public Connection getOrOpenConnection(Location location) {
        return this.connections.compute(location, (k, v) -> Optional.ofNullable(v).orElseGet(() -> this.open(location)));
    }

    public void onOpen(Connection connection) {
        this.connections.put(connection.remoteLocation(), connection);
    }

    public void onClose(Connection connection) {
        try {
            this.connections.remove(connection.remoteLocation()).close();
        }
        catch (Exception e) {
            log.error("Close connection error, remote: [{}]", (Object)connection.remoteLocation(), (Object)e);
        }
    }

    @Override
    public void close() throws Exception {
        for (Connection connection : this.connections.values()) {
            connection.close();
        }
    }
}

