/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.connection;

import io.dingodb.common.Location;
import io.dingodb.net.netty.channel.Channel;
import io.dingodb.net.netty.connection.Connection;
import io.netty.channel.socket.SocketChannel;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection
extends Connection {
    private static final Logger log = LoggerFactory.getLogger(ServerConnection.class);

    public ServerConnection(SocketChannel socketChannel) {
        super(new Location(socketChannel.remoteAddress().getHostName(), socketChannel.remoteAddress().getPort()), new Location(socketChannel.localAddress().getHostName(), socketChannel.localAddress().getPort()));
        this.socketChannel = socketChannel;
    }

    @Override
    protected Map<Long, Channel> createChannels() {
        return new ConcurrentHashMap<Long, Channel>();
    }

    @Override
    protected String channelName(String url, long id) {
        return String.format("<%s/%s/server>", url, id);
    }

    @Override
    public Channel newChannel(boolean keepAlive) {
        throw new UnsupportedOperationException("Server connection cannot create new channel.");
    }

    @Override
    public void receive(ByteBuffer message) {
        if (message == null) {
            return;
        }
        long channelId = message.getLong();
        Channel channel = (Channel)this.channels.get(channelId);
        if (channel == null) {
            channel = this.createChannel(channelId);
            this.channels.put(channelId, channel);
        }
        channel.receive(message);
    }
}

