/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.handler;

import io.dingodb.net.netty.connection.Connection;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MessageHandler.class);
    private final Connection connection;

    public MessageHandler(Connection connection) {
        this.connection = connection;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            if (in.readableBytes() > 0) {
                log.info("Channel is closed, discarding remaining {} byte(s) in buffer.", (Object)in.readableBytes());
            }
            in.skipBytes(in.readableBytes());
            return;
        }
        ByteBuffer message = MessageHandler.read(in);
        try {
            this.connection.receive(message);
        }
        catch (Exception e) {
            log.error("Handler message from [{}] error.", (Object)this.connection.remoteLocation());
        }
    }

    private static ByteBuffer read(ByteBuf buf) {
        if (buf.readableBytes() < 5) {
            return null;
        }
        buf.markReaderIndex();
        int length = buf.readInt();
        if (length < 0) {
            throw new CorruptedFrameException("Negative length: " + length);
        }
        if (length == 0) {
            throw new CorruptedFrameException("Received a message of length 0.");
        }
        if (!buf.isReadable(length)) {
            buf.resetReaderIndex();
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buf.readBytes(buffer);
        return (ByteBuffer)buffer.flip();
    }
}

