/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.handler;

import io.dingodb.net.Channel;
import io.dingodb.net.Message;
import io.dingodb.net.MessageListener;
import io.dingodb.net.MessageListenerProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(TagMessageHandler.class);
    public static final TagMessageHandler INSTANCE = new TagMessageHandler();
    private final Map<String, MessageListenerProvider> listenerProviders = new ConcurrentHashMap<String, MessageListenerProvider>();
    private final Map<String, Collection<MessageListener>> listeners = new ConcurrentHashMap<String, Collection<MessageListener>>();

    public static TagMessageHandler instance() {
        return INSTANCE;
    }

    private TagMessageHandler() {
    }

    public void setTagListenerProvider(String tag, MessageListenerProvider listenerProvider) {
        this.listenerProviders.put(tag, listenerProvider);
    }

    public void unsetTagListenerProvider(String tag) {
        this.listenerProviders.remove(tag);
    }

    public void addTagListener(String tag, MessageListener listener) {
        this.listeners.compute(tag, (k, v) -> {
            if (v == null) {
                v = new HashSet<MessageListener>();
            }
            v.add(listener);
            return v;
        });
    }

    public void removeTagListener(String tag, MessageListener listener) {
        this.listeners.compute(tag, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.remove(listener);
            if (v.isEmpty()) {
                return null;
            }
            return v;
        });
    }

    private void onTagMessage(Channel channel, Message message, MessageListener listener) {
        try {
            listener.onMessage(message, channel);
        }
        catch (Exception e) {
            log.error("Execute tag {} message listener error.", (Object)message.tag(), (Object)e);
        }
    }

    public void handler(Message message, Channel channel) {
        Collection<MessageListener> listeners;
        MessageListener listener2;
        String tag = message.tag();
        if (tag == null) {
            return;
        }
        MessageListenerProvider provider = this.listenerProviders.get(tag);
        if (provider != null && (listener2 = provider.get(message, channel)) != null) {
            channel.setMessageListener(listener2);
        }
        if ((listeners = this.listeners.get(tag)) == null || listeners.isEmpty()) {
            return;
        }
        listeners.forEach(listener -> this.onTagMessage(channel, message, (MessageListener)listener));
    }
}

