/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.net.netty.listener.impl;

import io.dingodb.common.concurrent.ThreadPoolBuilder;
import io.dingodb.net.netty.NetServiceConfiguration;
import io.dingodb.net.netty.connection.ConnectionManager;
import io.dingodb.net.netty.connection.ServerConnection;
import io.dingodb.net.netty.handler.ExceptionHandler;
import io.dingodb.net.netty.handler.MessageHandler;
import io.dingodb.net.netty.listener.PortListener;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

public class NettyServer
implements PortListener {
    private final ConnectionManager connectionManager;
    private final int port;
    private EventLoopGroup eventLoopGroup;
    private ServerBootstrap server;

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public void init() {
        this.server = new ServerBootstrap();
        this.eventLoopGroup = new NioEventLoopGroup(2, new ThreadPoolBuilder().name("Netty server " + this.port).build());
        ((ServerBootstrap)((ServerBootstrap)this.server.localAddress(this.port)).channel(NioServerSocketChannel.class)).group(this.eventLoopGroup).childHandler(this.channelInitializer());
    }

    @Override
    public void start() throws Exception {
        this.server.bind().sync().await();
    }

    private ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ServerConnection connection = new ServerConnection(ch);
                ch.pipeline().addLast(new MessageHandler(connection)).addLast(new IdleStateHandler(NetServiceConfiguration.INSTANCE.getHeartbeat().intValue(), 0L, 0L, TimeUnit.SECONDS)).addLast(new ExceptionHandler(connection));
                NettyServer.this.connectionManager.onOpen(connection);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> NettyServer.this.connectionManager.onClose(connection)));
            }
        };
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully();
    }

    NettyServer(ConnectionManager connectionManager, int port, EventLoopGroup eventLoopGroup, ServerBootstrap server) {
        this.connectionManager = connectionManager;
        this.port = port;
        this.eventLoopGroup = eventLoopGroup;
        this.server = server;
    }

    public static NettyServerBuilder builder() {
        return new NettyServerBuilder();
    }

    public static class NettyServerBuilder {
        private ConnectionManager connectionManager;
        private int port;
        private EventLoopGroup eventLoopGroup;
        private ServerBootstrap server;

        NettyServerBuilder() {
        }

        public NettyServerBuilder connectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        public NettyServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public NettyServerBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public NettyServerBuilder server(ServerBootstrap server) {
            this.server = server;
            return this;
        }

        public NettyServer build() {
            return new NettyServer(this.connectionManager, this.port, this.eventLoopGroup, this.server);
        }

        public String toString() {
            return "NettyServer.NettyServerBuilder(connectionManager=" + this.connectionManager + ", port=" + this.port + ", eventLoopGroup=" + this.eventLoopGroup + ", server=" + this.server + ")";
        }
    }
}

