/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.client;

import io.dingodb.common.Location;
import io.dingodb.net.NetService;
import io.dingodb.net.NetServiceProvider;
import io.dingodb.server.client.connector.impl.CoordinatorConnector;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBase {
    private static final Logger log = LoggerFactory.getLogger(ClientBase.class);
    private NetService netService;
    private CoordinatorConnector coordinatorConnector;
    private String coordinatorExchangeSvrList;

    public ClientBase(String coordinatorExchangeSvrList) {
        this.coordinatorExchangeSvrList = coordinatorExchangeSvrList;
    }

    public void initConnection() throws Exception {
        try {
            List<String> servers = Arrays.asList(this.coordinatorExchangeSvrList.split(","));
            List<Location> addrList = servers.stream().map(s2 -> s2.split(":")).map(ss -> new Location(ss[0], Integer.parseInt(ss[1]))).collect(Collectors.toList());
            this.coordinatorConnector = new CoordinatorConnector(addrList);
            this.netService = ServiceLoader.load(NetServiceProvider.class).iterator().next().get();
        }
        catch (Exception ex) {
            log.error("Failed to initialize connection: {}", (Object)this.coordinatorExchangeSvrList, (Object)ex);
            throw ex;
        }
    }

    public NetService getNetService() {
        return this.netService;
    }

    public CoordinatorConnector getCoordinatorConnector() {
        return this.coordinatorConnector;
    }
}

