/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.client;

import com.google.common.collect.ImmutableList;
import io.dingodb.common.CommonId;
import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.DingoExecResult;
import io.dingodb.common.operation.Operation;
import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.filter.DingoFilter;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.sdk.client.DingoConnection;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.Key;
import io.dingodb.sdk.common.Record;
import io.dingodb.sdk.operation.ContextForClient;
import io.dingodb.sdk.operation.ResultForClient;
import io.dingodb.sdk.operation.StoreOperationType;
import io.dingodb.sdk.operation.StoreOperationUtils;
import io.dingodb.sdk.operation.UDFContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoClient {
    private static final Logger log = LoggerFactory.getLogger(DingoClient.class);
    private DingoConnection connection;
    private StoreOperationUtils storeOpUtils;
    public static Integer retryTimes = 10;
    public static volatile boolean isConnectionInit = false;

    public DingoClient(String coordinatorExchangeSvrList) {
        this(coordinatorExchangeSvrList, retryTimes);
    }

    public DingoClient(String coordinatorExchangeSvrList, Integer retryTimes) {
        this.connection = new DingoConnection(coordinatorExchangeSvrList);
        DingoClient.retryTimes = retryTimes;
    }

    public boolean open() {
        try {
            if (this.isConnected()) {
                return true;
            }
            this.connection.initConnection();
            this.storeOpUtils = new StoreOperationUtils(this.connection, retryTimes);
            isConnectionInit = true;
            return true;
        }
        catch (Exception ex) {
            log.error("init connection failed", ex);
            return false;
        }
    }

    public boolean isConnected() {
        return isConnectionInit;
    }

    public void close() {
        if (this.storeOpUtils != null) {
            this.storeOpUtils.shutdown();
        }
        isConnectionInit = false;
    }

    public boolean createTable(TableDefinition tableDef) {
        String tableName;
        if (!this.isConnected()) {
            log.error("connection has not been initialized, please call openConnection first");
            return false;
        }
        String string = tableName = tableDef == null || tableDef.getName() == null ? "null" : tableDef.getName();
        if (tableDef == null || tableDef.getName() == null || tableDef.getName().isEmpty()) {
            log.error("Invalid TableDefinition:{}", (Object)tableDef);
            throw new DingoClientException.InvalidTableName(tableName);
        }
        DingoClient.copyColumnDefinition(tableDef);
        boolean isSuccess = false;
        try {
            this.connection.getMetaClient().createTable(tableName, tableDef);
            isSuccess = true;
            this.storeOpUtils.updateCacheOfTableDefinition(tableName, tableDef);
        }
        catch (Exception e) {
            isSuccess = false;
            log.error("create table: {} definition:{} failed:{}", tableDef.getName(), tableDef, e.toString(), e);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable(String tableName) {
        if (!this.isConnected()) {
            log.error("connection has not been initialized, please call openConnection first");
            return false;
        }
        if (tableName == null || tableName.isEmpty()) {
            log.error("Invalid table name:{}", (Object)tableName);
            throw new DingoClientException.InvalidTableName(tableName);
        }
        boolean isSuccess = false;
        try {
            isSuccess = this.connection.getMetaClient().dropTable(tableName.toUpperCase());
        }
        catch (Exception e) {
            isSuccess = false;
            log.error("drop table: {} failed:{}", tableName, e.toString(), e);
        }
        finally {
            this.storeOpUtils.removeCacheOfTableDefinition(tableName);
        }
        return isSuccess;
    }

    public TableDefinition getTableDefinition(String tableName) {
        if (!this.isConnected()) {
            log.error("connection has not been initialized, please call openConnection first");
            return null;
        }
        if (tableName == null || tableName.isEmpty()) {
            log.error("Invalid table name:{}", (Object)tableName);
            throw new DingoClientException.InvalidTableName(tableName);
        }
        TableDefinition tableDef = this.storeOpUtils.getTableDefinition(tableName);
        return tableDef;
    }

    public boolean insert(String tableName, List<Object[]> records, boolean skippedWhenExisted) {
        if (!this.isConnected()) {
            log.error("connection has not been initialized, please call openConnection first");
            return false;
        }
        if (records == null || records.size() == 0) {
            log.error("Invalid input rowList{}", (Object)records);
            return false;
        }
        HashMap<Key, Record> resultList = this.convertObjectArray2Record(tableName, records);
        ArrayList<Key> keyList = new ArrayList<Key>();
        ArrayList<Record> recordList = new ArrayList<Record>();
        for (Map.Entry<Key, Record> recordEntry : resultList.entrySet()) {
            keyList.add(recordEntry.getKey());
            recordList.add(recordEntry.getValue());
        }
        return this.doPut(keyList, recordList, skippedWhenExisted);
    }

    public boolean insert(String tableName, Object[] record) {
        ArrayList<Object[]> inputRecords = new ArrayList<Object[]>();
        inputRecords.add(record);
        return this.insert(tableName, inputRecords);
    }

    public boolean insert(String tableName, List<Object[]> records) {
        return this.insert(tableName, records, false);
    }

    private HashMap<Key, Record> convertObjectArray2Record(String tableName, List<Object[]> recordList) {
        TableDefinition tableDefinition = this.storeOpUtils.getTableDefinition(tableName);
        if (tableDefinition == null) {
            log.warn("table:{} definition not found", (Object)tableName);
            throw new DingoClientException.InvalidTableName(tableName);
        }
        int expectedCount = tableDefinition.getColumns().size();
        LinkedHashMap<Key, Record> recordResults = new LinkedHashMap<Key, Record>(recordList.size());
        for (Object[] record : recordList) {
            if (record == null || record.length == 0 || tableDefinition.getColumnsCount() != record.length) {
                log.error("Invalid record:{}, count: expect:{}, real:{}", record, tableDefinition.getColumnsCount(), record != null ? record.length : 0);
                int realCnt = record != null ? record.length : 0;
                throw new DingoClientException.InvalidColumnsCnt(realCnt, expectedCount);
            }
            ArrayList<Value> userKeys = new ArrayList<Value>();
            ArrayList<String> columnNames = new ArrayList<String>();
            int index = 0;
            for (ColumnDefinition column : tableDefinition.getColumns()) {
                if (column.isPrimary()) {
                    if (record[index] == null) {
                        throw new DingoClientException.InvalidPrimaryKeyData();
                    }
                    userKeys.add(Value.get(record[index]));
                }
                columnNames.add(column.getName());
                ++index;
            }
            int columnCnt = tableDefinition.getColumnsCount();
            Column[] columns = new Column[columnCnt];
            for (int i = 0; i < columnCnt; ++i) {
                columns[i] = new Column((String)columnNames.get(i), Value.get(record[i]));
            }
            Key key = new Key(tableName, userKeys);
            Record record1 = new Record(tableDefinition.getColumns(), columns);
            recordResults.put(key, record1);
        }
        return recordResults;
    }

    private static void copyColumnDefinition(TableDefinition tableDef) {
        List<ColumnDefinition> columnDefinitions = tableDef.getColumns().stream().map(c -> ColumnDefinition.builder().name(c.getName()).type(c.getType()).elementType(c.getElementType()).primary(c.isPrimary()).scale(c.getScale()).precision(c.getPrecision()).defaultValue(c.getDefaultValue()).notNull(c.isPrimary() || c.isNotNull()).build()).collect(Collectors.toList());
        tableDef.setColumns(columnDefinitions);
    }

    public boolean put(Key key, Column[] columns) {
        return this.put(key, columns, false);
    }

    public boolean put(Key key, Column[] columns, boolean skippedWhenExisted) {
        TableDefinition tableDefinition = this.storeOpUtils.getTableDefinition(key.getTable());
        Record record = new Record(tableDefinition.getColumns(), columns);
        return this.doPut(Arrays.asList(key), Arrays.asList(record), skippedWhenExisted);
    }

    public boolean put(List<Key> keyList, List<Record> recordList) {
        return this.put(keyList, recordList, false);
    }

    public boolean put(List<Key> keyList, List<Record> recordList, boolean skippedWhenExisted) {
        return this.doPut(keyList, recordList, skippedWhenExisted);
    }

    public Object[] get(String tableName, Object[] key) {
        ArrayList<Value> userKeys = new ArrayList<Value>();
        for (Object keyValue : key) {
            userKeys.add(Value.get(keyValue));
        }
        Key dingoKey = new Key(tableName, userKeys);
        Record dingoRecord = this.get(dingoKey);
        return dingoRecord.getDingoColumnValuesInOrder();
    }

    public Record get(Key key) {
        List<Record> records = this.doGet(Arrays.asList(key));
        if (records == null || records.isEmpty()) {
            return null;
        }
        return records.get(0);
    }

    public List<Record> get(List<Key> keyList) {
        return this.doGet(keyList);
    }

    public final List<Record> query(Key start, Key end, DingoFilter filter) {
        return this.doQuery(Arrays.asList(start), Arrays.asList(end), filter);
    }

    public boolean delete(String tableName, Object[] key) {
        ArrayList<Value> userKeys = new ArrayList<Value>();
        for (Object keyValue : key) {
            userKeys.add(Value.get(keyValue));
        }
        Key dingoKey = new Key(tableName, userKeys);
        return this.doDelete(Arrays.asList(dingoKey));
    }

    public boolean delete(Key key) {
        return this.doDelete(Arrays.asList(key));
    }

    public boolean delete(List<Key> keyList) {
        return this.doDelete(keyList);
    }

    private List<Record> doGet(List<Key> keyList) {
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.GET, keyList.get(0).getTable(), ContextForClient.builder().startKeyList(keyList).endKeyList(Collections.emptyList()).skippedWhenExisted(false).build());
        if (!result.getStatus()) {
            log.error("Execute get command failed:{}", (Object)result.getErrorMessage());
            return null;
        }
        return result.getRecords();
    }

    private boolean doPut(List<Key> keyList, List<Record> recordList, boolean skippedWhenExisted) {
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.PUT, keyList.get(0).getTable(), ContextForClient.builder().startKeyList(keyList).endKeyList(Collections.emptyList()).recordList(recordList).skippedWhenExisted(skippedWhenExisted).build());
        if (!result.getStatus()) {
            log.error("Execute put command failed:{}", (Object)result.getErrorMessage());
            return false;
        }
        return true;
    }

    private List<Record> doQuery(List<Key> startKeys, List<Key> endKeys, DingoFilter filter) {
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.QUERY, startKeys.get(0).getTable(), ContextForClient.builder().startKeyList(startKeys).endKeyList(endKeys).filter(filter).skippedWhenExisted(false).build());
        if (!result.getStatus()) {
            log.error("Execute query command failed:{}", (Object)result.getErrorMessage());
            return null;
        }
        return result.getRecords();
    }

    private boolean doDelete(List<Key> keyList) {
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.DELETE, keyList.get(0).getTable(), ContextForClient.builder().startKeyList(keyList).endKeyList(Collections.emptyList()).skippedWhenExisted(false).build());
        if (!result.getStatus()) {
            log.error("Execute put command failed:{}", (Object)result.getErrorMessage());
            return false;
        }
        return true;
    }

    public final boolean add(@Nonnull Key key, Column ... columns) {
        return this.add(key, false, columns);
    }

    public final boolean add(@Nonnull Key key, boolean useDefaultWhenNotExisted, Column ... columns) {
        Operation operation = Operation.add(useDefaultWhenNotExisted, columns);
        List<DingoExecResult> result = this.operate(key, ImmutableList.of(operation));
        return result != null && result.size() > 0 && result.get(0).isSuccess();
    }

    public final boolean add(@Nonnull Key start, @Nonnull Key end, Column ... columns) {
        return this.add(start, end, false, columns);
    }

    public final boolean add(@Nonnull Key start, @Nonnull Key end, boolean useDefaultWhenNotExisted, Column ... columns) {
        Operation operation = Operation.add(useDefaultWhenNotExisted, columns);
        List<DingoExecResult> result = this.operate(start, end, ImmutableList.of(operation));
        return result != null && result.size() > 0 && result.get(0).isSuccess();
    }

    public final boolean add(@Nonnull Key start, @Nonnull Key end, @Nonnull DingoFilter filter, Column ... columns) {
        Operation operation = Operation.add(false, columns);
        operation.operationContext.filter(filter);
        List<DingoExecResult> result = this.operate(start, end, ImmutableList.of(operation));
        return result != null && result.size() > 0 && result.get(0).isSuccess();
    }

    public final List<DingoExecResult> max(@Nonnull Key start, @Nonnull Key end, Column ... columns) {
        Operation operation = Operation.max(columns);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> max(@Nonnull Key start, @Nonnull Key end, @Nonnull DingoFilter filter, Column ... columns) {
        Operation operation = Operation.max(columns);
        operation.operationContext.filter(filter);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> min(@Nonnull Key start, @Nonnull Key end, Column ... columns) {
        Operation operation = Operation.min(columns);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> min(@Nonnull Key start, @Nonnull Key end, @Nonnull DingoFilter filter, Column ... columns) {
        Operation operation = Operation.min(columns);
        operation.operationContext.filter(filter);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> sum(@Nonnull Key start, @Nonnull Key end, Column ... columns) {
        Operation operation = Operation.sum(columns);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> sum(@Nonnull Key start, @Nonnull Key end, @Nonnull DingoFilter filter, Column ... columns) {
        Operation operation = Operation.sum(columns);
        operation.operationContext.filter(filter);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> count(@Nonnull Key start, @Nonnull Key end, @Nonnull DingoFilter filter, Column ... columns) {
        Operation operation = Operation.count(columns);
        operation.operationContext.filter(filter);
        return this.operate(start, end, ImmutableList.of(operation));
    }

    public final List<DingoExecResult> operate(@Nonnull Key key, @Nonnull List<Operation> operations) {
        ContextForClient contextForClient = ContextForClient.builder().startKeyList(ImmutableList.of(key)).operationList(operations).skippedWhenExisted(false).build();
        return this.storeOpUtils.doOperation(key.getTable().toUpperCase(), contextForClient);
    }

    public final List<DingoExecResult> operate(@Nonnull Key start, @Nonnull Key end, @Nonnull List<Operation> operations) {
        int endKeyCnt;
        int startKeyCnt = start.getUserKey() != null ? start.userKey.size() : 0;
        int n = endKeyCnt = end.getUserKey() != null ? end.userKey.size() : 0;
        if (startKeyCnt != endKeyCnt) {
            log.error("The number of primary keys in the start:{} and end:{} ranges is different", (Object)start, (Object)end);
            throw new DingoClientException.InvalidUserKeyCnt(startKeyCnt, endKeyCnt);
        }
        ContextForClient contextForClient = ContextForClient.builder().startKeyList(ImmutableList.of(start)).endKeyList(ImmutableList.of(end)).operationList(operations).skippedWhenExisted(false).build();
        return this.storeOpUtils.doOperation(start.getTable().toUpperCase(), contextForClient);
    }

    public boolean updateColumn(Key key, Column column) {
        Operation operation = Operation.update(column);
        List<DingoExecResult> result = this.operate(key, ImmutableList.of(operation));
        return result != null && result.size() > 0 && result.get(0).isSuccess();
    }

    public int registerUDF(String tableName, String udfName, String function) {
        CommonId id = this.connection.getMetaClient().getTableId(tableName);
        return this.connection.getMetaClient().registerUDF(id, udfName, function);
    }

    public boolean unregisterUDF(String tableName, String udfName, int version) {
        CommonId id = this.connection.getMetaClient().getTableId(tableName);
        return this.connection.getMetaClient().unregisterUDF(id, udfName, version);
    }

    public boolean updateRecordUsingUDF(String tableName, String udfName, String functionName, int version, List<Object> key) {
        ArrayList<Value> userKeys = new ArrayList<Value>();
        for (Object keyValue : key) {
            userKeys.add(Value.get(keyValue));
        }
        Key dingoKey = new Key(tableName, userKeys);
        UDFContext udfContext = new UDFContext(udfName, functionName, version);
        ContextForClient context = ContextForClient.builder().startKeyList(ImmutableList.of(dingoKey)).udfContext(udfContext).skippedWhenExisted(false).build();
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.UPDATE_UDF, tableName, context);
        return result.getStatus();
    }

    public Record getRecordByUDF(String tableName, String udfName, String functionName, int version, List<Object> key) {
        ArrayList<Value> userKeys = new ArrayList<Value>();
        for (Object keyValue : key) {
            userKeys.add(Value.get(keyValue));
        }
        Key dingoKey = new Key(tableName, userKeys);
        UDFContext udfContext = new UDFContext(udfName, functionName, version);
        ContextForClient context = ContextForClient.builder().startKeyList(ImmutableList.of(dingoKey)).udfContext(udfContext).skippedWhenExisted(false).build();
        ResultForClient result = this.storeOpUtils.doOperation(StoreOperationType.GET_UDF, tableName, context);
        return result.getRecords().get(0);
    }
}

