/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.client;

import io.dingodb.sdk.client.DingoClient;
import io.dingodb.sdk.client.IBaseDingoMapper;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.Key;
import io.dingodb.sdk.common.Record;
import io.dingodb.sdk.mappers.TypeMapper;
import io.dingodb.sdk.utils.CheckUtils;
import io.dingodb.sdk.utils.ClassCache;
import io.dingodb.sdk.utils.ClassCacheEntry;
import io.dingodb.sdk.utils.DeferredObjectLoader;
import io.dingodb.sdk.utils.LoadedObjectResolver;
import io.dingodb.sdk.utils.ThreadLocalKeySaver;
import io.dingodb.sdk.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class MappingConverter {
    private final IBaseDingoMapper mapper;
    private final DingoClient dingoClient;

    public MappingConverter(IBaseDingoMapper mapper, DingoClient dingoClient) {
        this.mapper = mapper;
        this.dingoClient = dingoClient;
    }

    public Object translateToDingo(Object obj) {
        if (obj == null) {
            return null;
        }
        TypeMapper thisMapper = TypeUtils.getMapper(obj.getClass(), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
        return thisMapper == null ? obj : thisMapper.toDingoFormat(obj);
    }

    public <T> T translateFromDingo(@NotNull Object obj, @NotNull Class<T> expectedClazz) {
        TypeMapper thisMapper = TypeUtils.getMapper(expectedClazz, TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
        Object result = thisMapper == null ? obj : thisMapper.fromDingoFormat(obj);
        this.resolveDependencies(ClassCache.getInstance().loadClass(expectedClazz, this.mapper));
        return (T)result;
    }

    public <T> T convertToObject(Class<T> clazz, Record record) {
        try {
            return this.convertToObject(clazz, record, null);
        }
        catch (ReflectiveOperationException e) {
            throw new DingoClientException(e);
        }
    }

    public <T> T convertToObject(Class<T> clazz, Record record, ClassCacheEntry<T> entry) throws ReflectiveOperationException {
        return this.convertToObject(clazz, record, entry, true);
    }

    public <T> T convertToObject(Class<T> clazz, Record record, ClassCacheEntry<T> entry, boolean resolveDependencies) throws ReflectiveOperationException {
        if (entry == null) {
            entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
        }
        T result = entry.constructAndHydrate(record);
        if (resolveDependencies) {
            this.resolveDependencies(entry);
        }
        return result;
    }

    public <T> T convertToObject(Class<T> clazz, List<Object> record) {
        return this.convertToObject(clazz, record, true);
    }

    public <T> T convertToObject(Class<T> clazz, List<Object> record, boolean resolveDependencies) {
        try {
            ClassCacheEntry<T> entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
            T result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            entry.hydrateFromList(record, result);
            if (resolveDependencies) {
                this.resolveDependencies(entry);
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new DingoClientException(e);
        }
    }

    public <T> T convertToObject(Class<T> clazz, Map<String, Object> record) {
        ClassCacheEntry<T> entry = ClassCache.getInstance().loadClass(clazz, this.mapper);
        return entry.constructAndHydrate(record);
    }

    public <T> List<Object> convertToList(@NotNull T instance) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(instance.getClass(), this.mapper);
        return entry.getList(instance, false, false);
    }

    public <T> Map<String, Object> convertToMap(@NotNull T instance) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(instance.getClass(), this.mapper);
        return entry.getMap(instance, false);
    }

    private Key createKey(ClassCacheEntry<?> entry, DeferredObjectLoader.DeferredObject deferredObject) {
        return null;
    }

    public void resolveDependencies(ClassCacheEntry<?> parentEntity) {
        List<DeferredObjectLoader.DeferredObjectSetter> deferredObjects = DeferredObjectLoader.getAndClear();
        if (deferredObjects.size() == 0) {
            return;
        }
        while (!deferredObjects.isEmpty()) {
            ArrayList<Key> keyList = new ArrayList<Key>();
            ArrayList classCacheEntryList = new ArrayList();
            Iterator<DeferredObjectLoader.DeferredObjectSetter> iterator = deferredObjects.iterator();
            while (iterator.hasNext()) {
                DeferredObjectLoader.DeferredObjectSetter thisObjectSetter = iterator.next();
                DeferredObjectLoader.DeferredObject deferredObject = thisObjectSetter.getObject();
                Class<?> clazz = deferredObject.getType();
                ClassCacheEntry<?> entry = CheckUtils.getEntryAndValidateTableName(clazz, this.mapper);
                Key aKey = this.createKey(entry, deferredObject);
                Object result = LoadedObjectResolver.get(aKey);
                if (result != null) {
                    thisObjectSetter.getSetter().setValue(result);
                    iterator.remove();
                    continue;
                }
                keyList.add(aKey);
                classCacheEntryList.add(entry);
            }
            int size = keyList.size();
            if (size > 0) {
                Key[] keys = keyList.toArray(new Key[0]);
                Object records = null;
                for (int i = 0; i < size; ++i) {
                    DeferredObjectLoader.DeferredObjectSetter thisObjectSetter = deferredObjects.get(i);
                    try {
                        ThreadLocalKeySaver.save(keys[i]);
                        Object result = records[i] == null ? null : this.convertToObject(thisObjectSetter.getObject().getType(), (Record)records[i], (ClassCacheEntry)classCacheEntryList.get(i), false);
                        thisObjectSetter.getSetter().setValue(result);
                        continue;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new DingoClientException(e);
                    }
                    finally {
                        ThreadLocalKeySaver.clear();
                    }
                }
            }
            deferredObjects = DeferredObjectLoader.getAndClear();
        }
    }
}

