/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.client;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.partition.PartitionStrategy;
import io.dingodb.common.util.ByteArrayUtils;
import io.dingodb.meta.Part;
import io.dingodb.net.api.ApiRegistry;
import io.dingodb.server.api.ExecutorApi;
import java.util.NavigableMap;

public class RouteTable {
    private String tableName;
    private CommonId tableId;
    private KeyValueCodec codec;
    private NavigableMap<ByteArrayUtils.ComparableByteArray, Part> partitionRange;
    private PartitionStrategy<ByteArrayUtils.ComparableByteArray> partitionStrategy;

    public ExecutorApi getLeaderAddress(ApiRegistry apiRegistry, String leaderAddress) {
        String hostName = leaderAddress.split(":")[0];
        String port = leaderAddress.split(":")[1];
        ExecutorApi executor = apiRegistry.proxy(ExecutorApi.class, () -> new Location(hostName, Integer.valueOf(port)));
        return executor;
    }

    public String getStartPartitionKey(ApiRegistry apiRegistry, byte[] keyInBytes) {
        ByteArrayUtils.ComparableByteArray byteArray = this.partitionStrategy.calcPartId(keyInBytes);
        Part part = (Part)this.partitionRange.get(byteArray);
        return part.getLeader().getHost() + ":" + part.getLeader().getPort();
    }

    public RouteTable(String tableName, CommonId tableId, KeyValueCodec codec, NavigableMap<ByteArrayUtils.ComparableByteArray, Part> partitionRange, PartitionStrategy<ByteArrayUtils.ComparableByteArray> partitionStrategy) {
        this.tableName = tableName;
        this.tableId = tableId;
        this.codec = codec;
        this.partitionRange = partitionRange;
        this.partitionStrategy = partitionStrategy;
    }

    public CommonId getTableId() {
        return this.tableId;
    }

    public KeyValueCodec getCodec() {
        return this.codec;
    }
}

