/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common;

public class DingoClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected int resultCode = -1005;

    public DingoClientException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public DingoClientException(int resultCode, Throwable exception) {
        super(exception);
        this.resultCode = resultCode;
    }

    public DingoClientException(int resultCode) {
        this.resultCode = resultCode;
    }

    public DingoClientException(int resultCode, String message, Throwable ex) {
        super(message, ex);
        this.resultCode = resultCode;
    }

    public DingoClientException(String message, Throwable ex) {
        super(message, ex);
    }

    public DingoClientException(String message) {
        super(message);
    }

    public DingoClientException(Throwable ex) {
        super(ex);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(512);
        String message = super.getMessage();
        sb.append("Error ");
        sb.append(this.resultCode);
        sb.append(": ");
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public static final class InvalidPrimaryKeyData
    extends DingoClientException {
        private static final long serialVersionUID = 1L;

        public InvalidPrimaryKeyData() {
            super(2007, "Invalid primary key, primary key is Empty");
        }
    }

    public static final class InvalidUserKeyCnt
    extends DingoClientException {
        private static final long serialVersionUID = 1L;

        public InvalidUserKeyCnt(int realKeyCnt, int expectedKeyCnt) {
            super(2002, "Invalid input userKeys, realCnt=" + realKeyCnt + ", expectedCnt=" + expectedKeyCnt);
        }
    }

    public static final class InvalidColumnsCnt
    extends DingoClientException {
        private static final long serialVersionUID = 1L;

        public InvalidColumnsCnt(int realColumnCnt, int expectedColumnCnt) {
            super(2003, "Invalid columns, realCnt=" + realColumnCnt + ", expectedCnt=" + expectedColumnCnt);
        }
    }

    public static final class InvalidTableName
    extends DingoClientException {
        private static final long serialVersionUID = 1L;

        public InvalidTableName(String tableName) {
            super(2006, tableName == null || tableName.length() == 0 ? "Invalid tableName is Empty!" : "Invalid tableName:" + tableName);
        }
    }

    public static final class Parse
    extends DingoClientException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-1004, message);
        }
    }
}

