/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common;

import io.dingodb.common.operation.Value;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Filter {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    private final Value[] startKey;
    private final Value[] endKey;
    private final String columnName;
    private final Value columnValueStart;
    private final Value columnValueEnd;

    public static Filter equal(Value[] startKey, Value[] endKey, String columnName, Value value) {
        return new Filter(startKey, endKey, columnName, value, value);
    }

    public static Filter contains(Value[] startKey, Value[] endKey, String columnName, Value value) {
        return new Filter(startKey, endKey, columnName, value, value);
    }

    public static Filter range(Value[] startKey, Value[] endKey, String columnName, Value begin, Value end) {
        return new Filter(startKey, endKey, columnName, begin, end);
    }

    private Filter(Value[] startKey, Value[] endKey, String columnName, Value columnValueStart, Value columnValueEnd) {
        this.startKey = startKey;
        this.endKey = endKey;
        this.columnName = columnName;
        this.columnValueStart = columnValueStart;
        this.columnValueEnd = columnValueEnd;
    }

    public String toString() {
        return "Filter { startKey=" + Arrays.toString(this.startKey) + ", endKey=" + Arrays.toString(this.endKey) + ", columnName=" + this.columnName + ", columnValueStart=" + this.columnValueStart + ", columnValueEnd=" + this.columnValueEnd + "}";
    }

    public Value[] getStartKey() {
        return this.startKey;
    }

    public Value[] getEndKey() {
        return this.endKey;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Value getColumnValueStart() {
        return this.columnValueStart;
    }

    public Value getColumnValueEnd() {
        return this.columnValueEnd;
    }
}

