/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common;

import com.google.common.collect.Maps;
import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.Value;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.sdk.annotation.DingoColumn;
import io.dingodb.sdk.annotation.DingoKey;
import io.dingodb.sdk.common.DingoClientException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Record {
    private static final Logger log = LoggerFactory.getLogger(Record.class);
    private final Map<String, Object> columnsInOrderMapping;
    private final List<String> keyColumns;

    public Record(List<ColumnDefinition> columnDefinitions, Column[] inputColumns) {
        this.keyColumns = new ArrayList<String>();
        this.columnsInOrderMapping = Maps.newLinkedHashMap();
        if (columnDefinitions.size() != inputColumns.length) {
            String errMsg = "Input Column Count mismatch. Table of Meta:" + columnDefinitions.size() + ", input real:" + inputColumns.length;
            throw new DingoClientException(errMsg);
        }
        block0: for (ColumnDefinition columnDefinition : columnDefinitions) {
            String columnName = columnDefinition.getName();
            if (columnDefinition.isPrimary()) {
                this.keyColumns.add(columnName);
            }
            for (Column column : inputColumns) {
                if (!Objects.equals(column.name, columnName)) continue;
                this.columnsInOrderMapping.put(columnName, column.value.getObject());
                continue block0;
            }
        }
    }

    public Record(Object instance) {
        this.keyColumns = new ArrayList<String>();
        this.columnsInOrderMapping = Maps.newLinkedHashMap();
        for (Field field : instance.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            if (field.isAnnotationPresent(DingoKey.class)) {
                this.keyColumns.add(fieldName);
            }
            if (field.isAnnotationPresent(DingoColumn.class)) {
                boolean isOK;
                String localFieldName = field.getAnnotation(DingoColumn.class).name();
                boolean bl = isOK = localFieldName != null && !localFieldName.isEmpty();
                if (isOK) {
                    fieldName = localFieldName;
                }
            }
            try {
                field.setAccessible(true);
                Object value = field.get(instance);
                this.columnsInOrderMapping.put(fieldName, value);
            }
            catch (IllegalAccessException e) {
                log.warn("Visit table columns using reflection failed.", e);
                throw new RuntimeException(e);
            }
        }
    }

    public Record(List<String> keyColumns, Map<String, Object> columns) {
        this.keyColumns = new ArrayList<String>(keyColumns.size());
        this.columnsInOrderMapping = Maps.newLinkedHashMap();
        boolean isValid = true;
        for (String string : keyColumns) {
            if (columns.containsKey(string)) continue;
            isValid = false;
            break;
        }
        if (!isValid) {
            log.error("Key columns:{} are not in the record:{}.", (Object)keyColumns, (Object)columns.keySet());
            throw new DingoClientException("Key columns are not in the record.");
        }
        for (String string : keyColumns) {
            this.keyColumns.add(string);
        }
        for (Map.Entry entry : columns.entrySet()) {
            this.columnsInOrderMapping.put((String)entry.getKey(), entry.getValue());
        }
    }

    public Object[] getDingoColumnValuesInOrder() {
        Object[] values = new Object[this.columnsInOrderMapping.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : this.columnsInOrderMapping.entrySet()) {
            values[i] = entry.getValue();
            ++i;
        }
        return values;
    }

    public static Record toDingoRecord(Record record) {
        ArrayList<String> keyColumns = new ArrayList<String>();
        for (String key : record.getKeyColumnNames()) {
            keyColumns.add(key);
        }
        HashMap<String, Object> columnsInOrder = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : record.columnsInOrderMapping.entrySet()) {
            Object value = entry.getValue();
            if (entry.getValue() instanceof Value) {
                value = ((Value)entry.getValue()).getObject();
            }
            columnsInOrder.put(entry.getKey(), value);
        }
        return new Record(keyColumns, columnsInOrder);
    }

    public List<String> getKeyColumnNames() {
        return this.keyColumns;
    }

    public List<Object> getColumnValuesInOrder() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : this.columnsInOrderMapping.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }

    public Object getValue(String name) {
        return this.columnsInOrderMapping == null ? null : this.columnsInOrderMapping.get(name);
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public double getDouble(String name) {
        Object result = this.getValue(name);
        return result instanceof Double ? (Double)result : (result != null ? Double.longBitsToDouble((Long)result) : 0.0);
    }

    public float getFloat(String name) {
        return (float)this.getDouble(name);
    }

    public long getLong(String name) {
        Object result = this.getValue(name);
        return result != null ? (Long)result : 0L;
    }

    public int getInt(String name) {
        return (int)this.getLong(name);
    }

    public short getShort(String name) {
        return (short)this.getLong(name);
    }

    public byte getByte(String name) {
        return (byte)this.getLong(name);
    }

    public boolean getBoolean(String name) {
        Object result = this.getValue(name);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result != null) {
            long v = (Long)result;
            return v != 0L;
        }
        return false;
    }

    public List<?> getList(String name) {
        return (List)this.getValue(name);
    }

    public Map<?, ?> getMap(String name) {
        return (Map)this.getValue(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("(columns:");
        if (this.columnsInOrderMapping != null) {
            boolean sep = false;
            for (Map.Entry<String, Object> entry : this.columnsInOrderMapping.entrySet()) {
                if (sep) {
                    sb.append(',');
                } else {
                    sep = true;
                }
                sb.append('(');
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue());
                sb.append(')');
                if (sb.length() <= 1000) continue;
                sb.append("...");
                break;
            }
        } else {
            sb.append("null");
        }
        sb.append(')');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.keyColumns, this.columnsInOrderMapping);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.keyColumns, other.keyColumns) && Objects.equals(this.columnsInOrderMapping, other.columnsInOrderMapping);
    }
}

